function LogCtrl($scope, $routeParams, Module, Message, Request, Backend){
	var module = 'log';
	Module.initSection('serverlog');
	Module.init(module, '服务日志信息');

	var route_path = $routeParams.path;
	var route_file = $routeParams.file;
	var remember_path = true;
	var remember_file = true;

	$scope.path = $scope.lastpath = '/root';
	$scope.curpath = '';
	$scope.showhidden = false;
	$scope.clipboard = {
		'srcpath': '',
		'count': 0,
		'items': {}	// name: copy|cut|link
	};
	$scope.confirm = $scope.cancel = function(){};

	var parse_path = function(){
		// parse dir to array/manage/logfile
		var pathnames = $scope.curpath.split('/');
		var pathinfos = [];
		for (var i=1; i<pathnames.length; i++) {
			if (!pathnames[i]) continue;
			var fullpath = pathnames[i-1]+'/'+pathnames[i];
			pathinfos.push({
				'name': pathnames[i],
				'path': fullpath
			});
			pathnames[i] = fullpath;
		}
		$scope.pathinfos = pathinfos;
		
	};
	
	$scope.loaded = false;
	//tab菜单切换时，切换到不同的路径，由此显示不同类型的日志文件
	$scope.load = function(sec){
		Module.setSection(sec);
		if (route_path || route_file) {	// load the specified path and file
			$scope.loaded = true;
			remember_path = false;
			remember_file = false;
			if (route_file){
				route_path = route_file.split('/')
				route_file = route_path.pop()
				route_path = route_path.join('/');
				if (!route_path) route_path = '/';
			}
			$scope.listdir(route_path, function(){
				if (route_file) $scope.editfile(route_file);
			});
		} else if (sec == "serverlog") {	// 服务日志文件
			Request.post('/manage/logfile', {
				'action': 'serverlog'
			}, function(data){
				if (data.code == 0) {
					$scope.loaded = true;
					var lastfile = data.data['lastfile'];
					var lastdir = data.data['lastdir'];
					$scope.listdir(lastdir, function(){
						if (lastfile && lastfile.indexOf(lastdir) === 0) {
							lastfile = lastfile.replace(lastdir+'/', '')
							if (lastfile.indexOf('/') == -1) $scope.editfile(lastfile);
						}
					});
				}
			}, false, true);
		} else if (sec == "attandposlog") {  //考勤消费失败日志文件
			Request.post('/manage/logfile', {
				'action': 'attandposlog'
			}, function(data){
				if (data.code == 0) {
					$scope.loaded = true;
					var lastfile = data.data['lastfile'];
					var lastdir = data.data['lastdir'];
					$scope.listdir(lastdir, function(){
						if (lastfile && lastfile.indexOf(lastdir) === 0) {
							lastfile = lastfile.replace(lastdir+'/', '')
							if (lastfile.indexOf('/') == -1) $scope.editfile(lastfile);
						}
					});
				}
			}, false, true);
		}
	};

	$scope.attandpos = function(){
		if (route_path || route_file) {	// load the specified path and file
			$scope.loaded = true;
			remember_path = false;
			remember_file = false;
			if (route_file){
				route_path = route_file.split('/')
				route_file = route_path.pop()
				route_path = route_path.join('/');
				if (!route_path) route_path = '/';
			}
			$scope.listdir(route_path, function(){
				if (route_file) $scope.editfile(route_file);
			});
		} else {	// load from history
			Request.post('/manage/logfile', {
				'action': 'attandpos'
			}, function(data){
				if (data.code == 0) {
					$scope.loaded = true;
					var lastfile = data.data['lastfile'];
					var lastdir = data.data['lastdir'];
					$scope.listdir(lastdir, function(){
						if (lastfile && lastfile.indexOf(lastdir) === 0) {
							lastfile = lastfile.replace(lastdir+'/', '')
							if (lastfile.indexOf('/') == -1) $scope.editfile(lastfile);
						}
					});
				}
			}, false, true);
		}
	};

	$scope.listdir = function(path, callback){
		if (path) $scope.path = path;
		if ($scope.path == '')
			$scope.path = '/root';
		else if ($scope.path != '/' && $scope.path.substr(-1) == '/')
			$scope.path = $scope.path.substr(0, $scope.path.length-1);
		$scope.path = $scope.path.replace('//', '/');

		var curpath = $scope.path;
		Request.post('/manage/logfile', {
			'action': 'listdir',
			'path': curpath,
			'showhidden': $scope.showhidden,
			'remember': remember_path
		}, function(data){
			if (data.code == 0) {
				$scope.items = data.data;
				$scope.curpath = curpath;
				$scope.lastpath = curpath;
				$scope.selects = {};
				$scope.selectall = false;
			} else {
				$scope.path = $scope.lastpath;
			}
			parse_path();
			if (callback) callback.call();
		}, false, true);
	};
	$scope.getitem = function(name, oldname){
		if (!oldname) oldname = name;
		Request.post('/manage/logfile', {
			'action': 'getitem',
			'path': $scope.curpath+'/'+name
		}, function(data){
			if (data.code == 0) {
				var iteminfo = data.data;
				// update to item list
				var found = false;
				for (var i=0; i<$scope.items.length; i++){
					if ($scope.items[i].name == oldname) {
						$scope.items[i] = iteminfo;
						found = true;
						break;
					}
				}
				// insert new item to proper position
				if (!found){
					var inserted = false;
					var i = 0;
					if (iteminfo.isdir || iteminfo.islnk && iteminfo.link_isdir) {
						for (; i<$scope.items.length; i++){
							var item = $scope.items[i];
							if (item.isdir || item.islnk && item.link_isdir) {
								if ($scope.items[i].name.localeCompare(iteminfo.name) > 1) {
									$scope.items.splice(i, 0, iteminfo);
									inserted = true;
									break;
								}
							} else {
								break;
							}
						}
					} else {
						for (; i<$scope.items.length; i++){
							var item = $scope.items[i];
							if (item.isdir || item.islnk && item.link_isdir) continue;
							if ($scope.items[i].name.localeCompare(iteminfo.name) > 1) {
								$scope.items.splice(i, 0, iteminfo);
								inserted = true;
								break;
							}
						}
					}
					if (!inserted) $scope.items.splice(i, 0, iteminfo);	// insert at the end of list
				}
			} else {	// item not found
				// delete to item list
				for (var i=0; i<$scope.items.length; i++){
					if ($scope.items[i].name == name) {
						$scope.items.splice(i, 1);
						break;
					}
				}
			}
		}, false, true);
	};
	//清空日志文件//////////////////
	$scope.cleanLog = function(path){
		$scope.confirm_title = '清空确认';
		$scope.confirm_body = '<p>清空后日志文件将不可恢复！</p><p>确认要清空 '+$scope.filename+' 吗？</p>';
		$('#confirm').modal();
		$scope.cancel = function(){};
		$scope.confirm = function(){
			Request.post('/manage/logfile', {
						'action':'cleanfile',
						'path':$scope.curpath+'/'+$scope.filename,
					},function(data){
							if (data.code == 0){
							//$scope.editfile($scope.filename);
							$scope.getitem($scope.filename);
							$scope.return2list();
							}
						});
		};
	};
	
	
	$scope.upandlist = function(){
		var patharr = $scope.curpath.split('/');
		patharr.pop();
		$scope.listdir( (patharr.join('/')? patharr.join('/') : '.')  +'/');
	};
	$scope.editfile = function(path){
		Request.post('/manage/logfile', {
			'action': 'fread',
			'path': $scope.curpath+'/'+path,
			'remember': remember_file
		}, function(data){
			if (data.code == 0) {
				Message.setSuccess('');
				var filedata = data.data;
				$scope.filename = filedata.filename;
				$scope.filepath = filedata.filepath;
				editor.setValue('');
				$('#list').hide();
				$('#edit').show();
				editor.setOption('mode', filedata.mimetype);
				editor.setValue(filedata.content);
				hasChange = false;
			}
		});
	};
	
	$scope.logload = function(path){
		url="http://192.168.0.22:8124/log/"+path;
		var log =window.open(url,"newwindow","width=300, height=300,status=1"); 
		log.document.execCommand("SaveAs"); 
		log.close();  
//		window.location=url;
//		
//		var str=$scope.curpath+'/../../../'+path;     
//		window.frames["hrong"].location.href=url;
//		sa();   
	}
	$scope.sa =function()   
	 {   
		if(window.frames["hrong"].document.readyState!="complete")   
			setTimeout("sa()",   100);   
		else   
			window.frames["hrong"].document.execCommand('SaveAs');   
	  }   
	
	
	$scope.download = function(){
		$('#download').modal();
		$scope.dodownload = function(){
			Backend.call(
				$scope,
				module,
				'/backend/wget',
				'/backend/wget_'+encodeURIComponent(encodeURIComponent($scope.downloadurl)),
				{
					'url': $scope.downloadurl,
					'path': $scope.curpath
				},
				{
					'success': function(data){
						$scope.listdir();
					}
				}
			);
		};
	};
	$scope.togglehidden = function(){
		$scope.showhidden = !$scope.showhidden;
		$scope.listdir();
	};
    
	var bindclipfunc = function(type){
		return function(name){
			var cb = $scope.clipboard;
			if (cb.srcpath != $scope.curpath) {
				cb.items = {};
				cb.count = 0;
			}
			if (typeof cb.items[name] == 'undefined') {
				cb.srcpath = $scope.curpath;
				cb.items[name] = type;
				cb.count++;
			} else if (cb.items[name] == type)  {
				delete cb.items[name];
				cb.count--;
			} else {
				cb.items[name] = type;
			}
		};
	}
	
	$scope.move2trash = function(name){
		Request.post('/manage/logfile', {
			'action': 'delete',
			'paths': $scope.curpath+'/'+name
		}, function(data){
			if (data.code == 0) {
				$scope.getitem(name);
			}
		});
	};
	$scope.compressconfirm = function(name, isreg){
		$scope.compress_isreg = isreg;
		$scope.compress_type = isreg ? '.gz' : '.tar.gz';
		$scope.compress_zipname = name;
		$scope.compress_name = name;
		$scope.compress_names = [];
		$('#compressconfirm').modal();
	};
	$scope.compress = function(){
		var zippath = $scope.curpath+'/'+$scope.compress_zipname+$scope.compress_type;
		var srcpath = $scope.curpath+'/'+$scope.compress_name;
		Backend.call(
			$scope,
			module,
			'/backend/compress',
			'/backend/compress_'+zippath+'_'+srcpath, 
			{
				'zippath': zippath,
				'paths': srcpath
			},
			{
				'success': function(data){
					var newname = $scope.compress_zipname+$scope.compress_type;
					if ($scope.compress_type == '.gz')
						$scope.getitem(newname, $scope.compress_name);
					else
						$scope.getitem(newname);
				}
			}
		);
	};

    $scope.$watch('selectall', function(value) {
        angular.forEach($scope.items, function(item) {
            $scope.selects[item.name] = value;
        });
    });
    $scope.return2list = $scope.canceledit = function(){
			$('#edit').hide();
			$('#list').show();
			Request.post('/manage/logfile', {'action': 'fclose'}, false, false, true);
    	};
    	$scope.savefile = function(){
    		if (!hasChange) {
    			Message.setInfo('文件未修改，无须保存！');
    			return;
    		}
    		Request.post('/operation/file', {
    			'action': 'fwrite',
    			'path': $scope.filepath,
    			'content': editor.getValue()
    		}, function(data){
    			if (data.code == 0) {
    				hasChange = false;
    				$scope.getitem($scope.filename);
    			}
    		});
    	};
    
	$scope.multidel = function(){
		var paths = [];
		angular.forEach($scope.selects, function(selected, item){
			if (selected) paths.push($scope.curpath+'/'+item);
		});
		if (paths.length == 0) return;
		Request.post('/manage/logfile', {
			'action': 'delete',
			'paths': paths.join(',')
		}, function(data){
			if (data.code == 0) {
				$scope.listdir();
			}
		});
	};

	var hasChange = false;
	var editor = CodeMirror(document.getElementById('editor'), {
		value: '',
		lineNumbers: true,
		lineWrapping: true,
		matchBrackets: true,
		onCursorActivity: function() {
			editor.setLineClass(hlLine, null, null);
			hlLine = editor.setLineClass(editor.getCursor().line, null, 'activeline');
			// disable match highlight in IE, or it will slow down the page
			if (!$.browser.msie) editor.matchHighlight('CodeMirror-matchhighlight');
		},
		onChange: function() {
			hasChange = true;
		}
	});
	var hlLine = editor.setLineClass(0, 'activeline');
}
